﻿namespace Code6587EN.Ch07.Controls
{
    using Microsoft.SharePoint.Utilities;
    using Microsoft.SharePoint.WebControls;
    using System.Globalization;
    using System.IO;
    using System.Web.UI;

    /// <summary>
    /// ASP.NET user control implementing the SharePoint design time HTML provider interface to render a 
    /// custom promoted action on the page.
    /// </summary>
    public class CustomPromotedAction : UserControl, IDesignTimeHtmlProvider
    {
        // Implement the GetDesignTimeHtml method from the IDesignTimeHtmlProvider interface
        // to return the HTML to render
        public string GetDesignTimeHtml()
        {
            // Wrap the code in an SPMonitoredScope
            // http://msdn.microsoft.com/en-us/library/ff512758(v=office.14).aspx
            using (new SPMonitoredScope("Code6587EN.Ch07.Controls.CustomPromotedAction::GetDesignTimeHtml"))
            {
                // Instantiate a new HtmlTextWriter object to construct the HTML for the promoted action
                StringWriter writer = new StringWriter(CultureInfo.CurrentCulture);
                HtmlTextWriter writer2 = new HtmlTextWriter(writer);

                // Call the overridden Render method to construct the HTML
                this.Render(writer2);
                writer2.Close();

                // Return the HTML constructed by the Render method
                return writer.ToString();
            }
        }

        // Override the Render method to be used by the GetDesignTimeHtml method to construct the HTML to render
        protected override void Render(HtmlTextWriter writer)
        {
            // Wrap the code in an SPMonitoredScope
            // http://msdn.microsoft.com/en-us/library/ff512758(v=office.14).aspx
            using (new SPMonitoredScope("Code6587EN.Ch07.Controls.CustomPromotedAction::Render"))
            {
                // Get the URL to the themed SharePoint common image sprite
                var iconUrl = SPUtility.GetThemedImageUrl("/_layouts/15/images/spcommon.png", "spcommon");

                // Add the CSS styling required for the promoted actions button
                writer.AddAttribute(HtmlTextWriterAttribute.Type, "text/css");
                writer.RenderBeginTag(HtmlTextWriterTag.Style);
                writer.Write("#customPromotedActionIcon { height:16px; width:16px; position:relative; display:inline-block; overflow:hidden; background-image: url('" + iconUrl + "'); background-position: -218px -48px; }");
                writer.RenderEndTag();

                // Add the link (<a>) element
                writer.AddAttribute(HtmlTextWriterAttribute.Id, "customPromotedAction");
                writer.AddAttribute(HtmlTextWriterAttribute.Class, "ms-promotedActionButton");
                writer.AddAttribute(HtmlTextWriterAttribute.Href, "#");
                writer.AddAttribute("onclick", "alert('You clicked the promoted action.');");
                writer.RenderBeginTag(HtmlTextWriterTag.A);

                // Add the span element to display the icon
                writer.AddAttribute(HtmlTextWriterAttribute.Class, "s4-clust ms-promotedActionButton-icon");
                writer.AddAttribute(HtmlTextWriterAttribute.Id, "customPromotedActionIcon");
                writer.RenderBeginTag(HtmlTextWriterTag.Span);
                writer.Write("&nbsp;");
                writer.RenderEndTag();

                // Add the span element to display the text
                writer.AddAttribute(HtmlTextWriterAttribute.Class, "ms-promotedActionButton-text");
                writer.RenderBeginTag(HtmlTextWriterTag.Span);
                writer.Write("Custom Action");
                writer.RenderEndTag();

                // Close the link (<a>) element
                writer.RenderEndTag();
            }
        }
    }
}
